package jamezo97.clonecraft.network;

import jamezo97.clonecraft.dna.Gene;
import jamezo97.clonecraft.dna.GeneTeleport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.CCEntityClientPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.CCEntityPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.Vec3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class Handler17TeleportPlayer extends Handler{

	@Value(id = 0)
	int newX;
	@Value(id = 1)
	int newY;
	@Value(id = 2)
	int newZ;
	
	
	public Handler17TeleportPlayer() {

	}

	public Handler17TeleportPlayer(EntityLivingBase entity, int newX, int newY, int newZ) {
		this.newX = newX;
		this.newY = newY;
		this.newZ = newZ;
	}



	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		if(side == Side.SERVER){
			if(player instanceof CCEntityPlayerMP && ((CCEntityPlayerMP)player).hasGene(Gene.teleport)){
				Vec3 tpTo = GeneTeleport.getClosestValidTPCoord(newX, newY, newZ, player);
				
				double bx = player.posX, by = player.posY, bz = player.posZ;
				
				
				if(tpTo != null){
					double dx = (tpTo.xCoord - bx);
					double dy = (tpTo.yCoord - by);
					double dz = (tpTo.zCoord - bz);
					
					double distanceSq = (dx*dx + dy*dy + dz*dz);
					
					if(distanceSq < GeneTeleport.getMaxTPDistanceSqrd()){
						if(!player.capabilities.isCreativeMode){
							player.addExhaustion(0.01f);
						}
						new Handler18TPEffects(bx, by, bz, tpTo.xCoord+0.5f, tpTo.yCoord+0.5f, tpTo.zCoord+0.5f, player).sendToAllWatchingIncluding(player);
						player.setPosition(tpTo.xCoord + 0.5f, tpTo.yCoord, tpTo.zCoord + 0.5f);
					}
				}
			}else{
				player.sendChatToPlayer(ChatMessageComponent.createFromText("Are you trying to cheat or something? :)"));
			}
			
		}
	}
	

}
